// Test the URL regular expression
IWUTAssert( ("http://com/".isHTTPURL() == true), "Expecting URL to match the HTTP URL regular expression.");
IWUTAssert( ("https://prod.apple.com/confluence/display/IWEB/RSS+Feed+Widget".isHTTPURL() == true), "Expecting URL to match the HTTP URL regular expression.");
IWUTAssert( ("https://pr+od.apple.com/confluence/display/IWEB/RSS+Feed+Widget".isHTTPURL() == false), "Expecting malformed URL not to match the HTTP URL regular expression.");
IWUTAssert( ("http://istweb.apple.com/search/?q=rss%20feed&restrict=istweb_only&client=internal_collection&site=internal_collection&lr=lang_en&output=xml&sort=&filter=&access=p".isHTTPURL() == true), "Expecting URL to match the HTTP URL regular expression.");
IWUTAssert( ("feed://istweb.apple.com:80/search/?q=rss%20feed&restrict=istweb_only&client=internal_collection&site=internal_collection&lr=lang_en&output=xml&sort=&filter=&access=p".isHTTPURL() == true), "Expecting URL to match the HTTP URL regular expression.");
IWUTAssert( ("feed://a0a.Z.a:80/f/A//?".isHTTPURL() == true), "Expecting URL to match the HTTP URL regular expression.");
IWUTAssert( ("ftp://a0a.Z.a:80/f/A//?".isHTTPURL() == false), "Expecting FTP URL not to match the HTTP URL regular expression.");
IWUTAssert( ("://".isHTTPURL() == false), "Expecting malformed URL not to match the HTTP URL regular expression.");
IWUTAssert( ("bleah".isHTTPURL() == false), "Expecting malformed URL not to match the HTTP URL regular expression.");
IWUTAssert( ("".isHTTPURL() == false), "Expecting malformed URL not to match the HTTP URL regular expression.");

// URL massaging
var massage = RSSFeedWidget.prototype.p_massageURL;
IWUTAssert( (massage(" http://www.apple.com  ") == "http://www.apple.com"), "Problem massaging feed - strip");
IWUTAssert( (massage("www.apple.com") == "http://www.apple.com"), "Problem massaging feed - prepend");
IWUTAssert( (massage("feed://www.apple.com") == "http://www.apple.com"), "Problem massaging feed - convert feed://");

// Content parsing
var parse = RSSFeedWidget.prototype.p_parseContent;
var result = null;

result = parse('<table><td>Text</td></table>', null);
IWUTAssert( result.content == 'Text' && result.inlineImages == null, 'Problem parsing content');

result = parse('<table><td><a href="#">Text</a></td></table>', null);
IWUTAssert( result.content == '<a href="#">Text</a>' && result.inlineImages == null, 'Problem parsing content - preserve anchor tags... result: ' + result.content);

result = parse('<p><b><i><s><u>Text</u></s></i></b></p>', null);
IWUTAssert( result.content == '<b><i><s><u>Text</u></s></i></b><br />' && result.inlineImages == null, 'Problem parsing content - preserve style tags... result: ' + result.content);

result = parse('<p>image here:<img src="foo.jpg"/></p>', null);
IWUTAssert( result.content == 'image here:<br />' && result.inlineImages != null && result.inlineImages.length == 1, 'Problem parsing content - enclosure substitution... result.content: ' + result.content + ', result.inlineImages: ' + result.inlineImages);

result = parse('<p>image here:<img src="foo.jpg"/><img src="bar.jpg"/></p>', null);
IWUTAssert( result.content == 'image here:<br />' && result.inlineImages != null && result.inlineImages.length == 2, 'Problem parsing content - should return more than one inline');

result = parse('<p>image here:<a href="#"><img src="foo.jpg" alt="Alt text"/></a></p>', null);
IWUTAssert( result.content == 'image here:<a href="#">Alt text</a><br />' && result.inlineImages != null && result.inlineImages.length == 1, 'Problem parsing content - image replacement by alt text... result.content: ' + result.content + ', result.inlineImages: ' + result.inlineImages);

result = parse('<p>image here:<img src="foo.jpg" alt="Alt text"/></p>', {url: 'bar.jpg'});
IWUTAssert( result.content == 'image here:<br />' && result.inlineImages == null, 'Problem parsing content - image removal when enclosure is present... result.content: ' + result.content + ', result.inlineImages: ' + result.inlineImages);

var xssEscapedJavascript = '&lt;a href=&quot;http://alienlan.apple.com/alienlan/xss/Blog_1/Entries/2008/10/15_hack_1_files/dv2069005_med.jpg&quot;&gt;&lt;img src=&quot;http://alienlan.apple.com/alienlan/xss/Blog_1/Media/object001_1.jpg&quot; style=&quot;float:left; padding-right:10px; padding-bottom:10px; width:251px; height:188px;&quot;/&gt;&lt;/a&gt;\';alert(String.fromCharCode(88,83,83))//\\\';alert(String.fromCharCode(88,83,83))//&amp;quot;;alert(String.fromCharCode(88,83,83))//\&amp;quot;;alert(String.fromCharCode(88,83,83))//--&gt;&amp;lt;/SCRIPT&gt;&amp;quot;&gt;\'&gt;&amp;lt;SCRIPT&gt;alert(String.fromCharCode(88,83,83))&amp;lt;/SCRIPT&gt;';
result = parse(attackEscapedJavascript, null);
IWUTAssert( result.content == xssEscapedJavascript && result.inlineImages == null, 'Problem parsing content - attack XSS escaped Javascript incorrectly escaped:' + result.content + ', result.inlineImages: ' + result.inlineImages);
